!Object constantsFor: 'Geos Libraries'!

geosLIB79 'SYSTEM\viewer'! !

!Object constantsFor: 'Geos vardata'!

attrFileOpenDefaultDirectory 34816!
attrFileOpenDefaultFileNamePrefix 34820!
attrFileOpenCreateTriggerMoniker 34824!
attrFileOpenFileAttrInfo 34828!
attrFileOpenViewerLibName 34832!
attrFileOpenFilterIsC 34836!
attrFileOpenFilter 34840!
attrFileOpenIncludeDir 34844!
attrFileOpenExcludeDir 34848!
attrFileOpenIncludeFile 34852!
attrFileOpenExcludeFile 34856!
tempFileOpenFileSelectorInfo 34860!
tempFsSelection 34864!
hintFileOpenDontFilterDocumentSubDirs 34868!
tempFileOpenControlLastUi 34872!
tempFileOpenControlDestinationPath 34876!
tempFocSelectorInfo 34880!
tempFileOpenControlFileOperationInProgress 34884!
tempFileOpenControlNewDoc 34888!
tempFileOpenControlSomeIrDocsAreOpen 34892!
tempHeapspaceToken 27136!
tempViewerDocInfo 27648!
attrViewerTextObject 27652!
tempRegisterInfo 27656!
attrViewerControlShowSaveProgressDialogThreshold 27660!
tempViewerLoadingMeter 27664!
hintViewerNoDocumentRename 27668!
tempViewerOriginalText 27672!
attrViewerControlShowDeleteProgressDialogThreshold 27676!
attrViewerSendControlReplySendMoniker 28160!
tempViewerSendControlSingleTransport 28164!
tempViewerSendControlComplexMoniker 28168!
tempViewerSendControlReplyInProgress 28172!
tempViewerSendControlNoSeekReplyBarIsOk 28176!
tempViewerSendControlEnableOptionsOptr 28180!
attrViewerSendControlOptionsOptr 28184!
!

!Object constantsFor: 'Geos messages'!

openControlOpen 34816!
openControlGetViewerLibraryName 34817!
openControlCreateNew 34818!
openControlDelete 34819!
openControlRenameCopy 34820!
openControlItemSelected 34821!
openControlSetDirectory 34822!
openControlGetDirectory 34823!
openControlGetFilterRoutine 34824!
openControlSubDirOpen 34825!
openControlSubDirClose 34826!
openControlRenameDocument 34827!
openControlCopyDocument 34828!
openControlChangeFeatures 34829!
openControlGetFileSelectorOptr 34830!
open 34831!
close 34832!
createNew 34833!
unloadViewerLibrary 34834!
nextPrevDocument 34835!
nextPrevGetNewDoc 34836!
renameDoc 34837!
copyDoc 34838!
checkIncludeExcludeDir 34839!
checkIncludeExcludeFile 34840!
openFolder 34841!
setFileSelectorSelection 34842!
openControlDeleteCallback 34843!
menu 34844!
createFolder 34845!
copyDestReady 34846!
moveDoc 34847!
openControlCreateFolder 34848!
openControlRename 34849!
openControlCopy 34850!
openControlMove 34851!
openControlChangeFeatures_16 34852!
openControlGetUnreadDocument 34853!
openControlCloseAllBubbles 34854!
openControlLoadUnreadDocument 34855!
openControlCopyToSounds 34856!
deleteFileOpVarDataViaQueue 34857!
openControlCopyViaIr 34858!
openControlCopyOneFileViaIr 34859!
openControlCopyViaIrCleanup 34860!
openControlCopyViaIrMailboxError 34861!
openControlCopyViaIrTooManyFiles 34862!
setViewerParams 27136!
close 27137!
setDialogAttr 27138!
setHeapspaceToken 27139!
returnHeapspace 27140!
setAlternateVscParent 27136!
open 27648!
openDocument 27649!
closeDocument 27650!
attachUi 27651!
setTitle 27652!
close 27653!
save 27654!
delete 27655!
getTextObjectOffset 27656!
returnState 27657!
openFromState 27658!
autoSaveStart 27659!
autoSave 27660!
autoSaveStop 27661!
openReadOnly 27662!
getDocumentInfo 27663!
getMessageFormat 27664!
getAttributes 27665!
openTextOnly 27666!
getMessageToken 27667!
getSmText 27668!
saveBeforeMailboxSend 27669!
notifySendControls 27670!
autoSaveExecute 27671!
appendDosText 27672!
appendTextTrItem 27673!
precheckMailboxMessageFormat 27674!
loadingMeterSetValue 27648!
loadingMeterSetMaximum 27649!
loadingMeterSetFocusObject 27650!
checkForFaxForwarding 28160!
alwaysTile 28161!
alwaysScale 28162!
checkForFaxing 28163!
connect 28160!
disconnect 28161!
setReplyAddresses 28162!
cancelReply 28163!
setOptionsAction 28164!
!

!Geos class methodsFor: 'library calls'!

ViewerGetLibrary: docInfo with: fname
	"ViewerInterfaceError pascal ViewerGetLibrary(DocumentInfo *docInfo, FileLongName *fname) in viewer.goh"
	^GEOS call: docInfo with: fname with: #[79 0 14 3 3 1]!

ViewerGetLibraryNameFromToken: token with: libName
	"Boolean pascal ViewerGetLibraryNameFromToken(TokenChars *token, FileLongName *libName) in viewer.goh"
	^GEOS call: token with: libName with: #[79 0 15 3 3 4]!

ViewerAddLibrary: libName with: token
	"Boolean pascal ViewerAddLibrary(FileLongName *libName, GeodeToken *token) in viewer.goh"
	^GEOS call: libName with: token with: #[79 0 16 3 3 4]!

ViewerUnloadLibrary: libHandle
	"Boolean pascal ViewerUnloadLibrary(hptr libHandle) in viewer.goh"
	^GEOS call: libHandle with: #[79 0 17 1 4]!

ViewerGetFileToken: docInfo with: token
	"ViewerInterfaceError pascal ViewerGetFileToken(DocumentInfo *docInfo, GeodeToken *token) in viewer.goh"
	^GEOS call: docInfo with: token with: #[79 0 18 3 3 1]!

ViewerLibraryOpen: viewerParams with: uiOptr
	"hptr pascal ViewerLibraryOpen(ViewerParams viewerParams, optr *uiOptr) in viewer.goh"
	^GEOS call: viewerParams with: uiOptr with: #[79 0 19 64 92 3 1]!

ViewerLibraryDetach: libHandle with: uiOptr
	"hptr pascal ViewerLibraryDetach(hptr libHandle, optr uiOptr) in viewer.goh"
	^GEOS call: libHandle with: uiOptr with: #[79 0 20 1 2 1]!

ViewerLibraryChangeDocument: libHandle with: vcds
	"ViewerCloseStatus pascal ViewerLibraryChangeDocument(hptr libHandle, ViewerChangeDocumentStruct *vcds) in viewer.goh"
	^GEOS call: libHandle with: vcds with: #[79 0 21 1 3 1]!

ViewerLibraryClose: libHandle with: uiOptr
	"pascal ViewerLibraryClose(hptr libHandle, optr uiOptr) in viewer.goh"
	^GEOS call: libHandle with: uiOptr with: #[79 0 22 1 2 4]!

ViewerMarkFileRead: fileH
	"pascal ViewerMarkFileRead(FileHandle fileH) in viewer.goh"
	^GEOS call: fileH with: #[79 0 26 1 4]!

ViewerMarkFileUnread: fileH
	"pascal ViewerMarkFileUnread(FileHandle fileH) in viewer.goh"
	^GEOS call: fileH with: #[79 0 27 1 4]!

ViewerAddSendControl: newOutput with: newParentOffset
	"void pascal ViewerAddSendControl(optr newOutput, word newParentOffset) in viewer.goh"
	^GEOS call: newOutput with: newParentOffset with: #[79 0 30 2 1 0]!

ViewerRemoveSendControl: output with: vcs
	"void pascal ViewerRemoveSendControl(optr output, ViewerCloseStatus vcs) in viewer.goh"
	^GEOS call: output with: vcs with: #[79 0 31 2 1 0]!

ViewerSendDocumentNotification: memH
	"void pascal ViewerSendDocumentNotification(MemHandle memH) in viewer.goh"
	^GEOS call: memH with: #[79 0 33 1 0]!

ViewerSetSendControlOptions: optionsTree
	"void pascal ViewerSetSendControlOptions(optr optionsTree) in viewer.goh"
	^GEOS call: optionsTree with: #[79 0 41 2 0]!

!

ComplexMoniker subclass: #FileOpenControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #ViewerDialog
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #ViewerMenuInteraction
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ViewerControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ViewerLoadingMeter
	instanceVariableNames: ''
	classVariableNames: ''!

PrintControl subclass: #ViewerPrintControl
	instanceVariableNames: ''
	classVariableNames: ''!

MailboxSendControl subclass: #ViewerSendControl
	instanceVariableNames: ''
	classVariableNames: ''!

!FileOpenControl comment!
Library viewer, file viewer.goh! !

!FileOpenControl class methodsFor: 'library linkage'!

library
	^79!

entry
	^0!
!

!FileOpenControl methodsFor: 'Geos instance variables'!

foiViewerLibraryOpenCount
	"@instance byte FOI_viewerLibraryOpenCount"
	^self byteAt: 10!

foiViewerLibraryOpenCount: value
	"@instance byte FOI_viewerLibraryOpenCount"
	^self byteAt: 10 put: value!

foiViewerLibraryHandle
	"@instance hptr FOI_viewerLibraryHandle"
	^self wordAt: 11!

foiViewerLibraryHandle: value
	"@instance hptr FOI_viewerLibraryHandle"
	^self wordAt: 11 put: value!

foiViewerLibraryUIOD
	"@instance optr FOI_viewerLibraryUIOD"
	^self dwordAt: 13!

foiViewerLibraryUIOD: value
	"@instance optr FOI_viewerLibraryUIOD"
	^self dwordAt: 13 put: value!

foiViewerLibraryStateChunk
	"@instance ChunkHandle FOI_viewerLibraryStateChunk"
	^self wordAt: 17!

foiViewerLibraryStateChunk: value
	"@instance ChunkHandle FOI_viewerLibraryStateChunk"
	^self wordAt: 17 put: value!

foiFolderTextChunk
	"@instance word FOI_folderTextChunk"
	^self wordAt: 19!

foiFolderTextChunk: value
	"@instance word FOI_folderTextChunk"
	^self wordAt: 19 put: value!

foiViewerAttr
	"@instance ViewerAttributes FOI_viewerAttr"
	^self wordAt: 21!

foiViewerAttr: value
	"@instance ViewerAttributes FOI_viewerAttr"
	^self wordAt: 21 put: value!

!

!FileOpenControl methodsFor: 'Geos vardata'!

attrFileOpenDefaultDirectory: value
	"@vardata FDocumentDir ATTR_FILE_OPEN_DEFAULT_DIRECTORY"
	^self addVardata: ##attrFileOpenDefaultDirectory word: value!

attrFileOpenDefaultFileNamePrefix: value
	"@vardata ChunkHandle ATTR_FILE_OPEN_DEFAULT_FILE_NAME_PREFIX"
	^self addVardata: ##attrFileOpenDefaultFileNamePrefix word: value!

attrFileOpenCreateTriggerMoniker: value
	"@vardata ChunkHandle ATTR_FILE_OPEN_CREATE_TRIGGER_MONIKER"
	^self addVardata: ##attrFileOpenCreateTriggerMoniker word: value!

attrFileOpenFileAttrInfo
	"@vardata FileAttrInfo ATTR_FILE_OPEN_FILE_ATTR_INFO"
	^self addVardata: ##attrFileOpenFileAttrInfo size: 10!

attrFileOpenFileAttrInfo: aBlock
	"@vardata FileAttrInfo ATTR_FILE_OPEN_FILE_ATTR_INFO"
	aBlock value: (GCSFileAttrInfo forPointer: (self addVardata: ##attrFileOpenFileAttrInfo size: 10)).!

attrFileOpenViewerLibName
	"@vardata FileLongName ATTR_FILE_OPEN_VIEWER_LIB_NAME"
	^self addVardata: ##attrFileOpenViewerLibName size: 36!

attrFileOpenFilterIsC
	"@vardata void ATTR_FILE_OPEN_FILTER_IS_C"
	^self addVardata: ##attrFileOpenFilterIsC!

attrFileOpenFilter
	"@vardata void ATTR_FILE_OPEN_FILTER"
	^self addVardata: ##attrFileOpenFilter!

attrFileOpenIncludeDir: value
	"@vardata ChunkHandle ATTR_FILE_OPEN_INCLUDE_DIR"
	^self addVardata: ##attrFileOpenIncludeDir word: value!

attrFileOpenExcludeDir: value
	"@vardata ChunkHandle ATTR_FILE_OPEN_EXCLUDE_DIR"
	^self addVardata: ##attrFileOpenExcludeDir word: value!

attrFileOpenIncludeFile: value
	"@vardata ChunkHandle ATTR_FILE_OPEN_INCLUDE_FILE"
	^self addVardata: ##attrFileOpenIncludeFile word: value!

attrFileOpenExcludeFile: value
	"@vardata ChunkHandle ATTR_FILE_OPEN_EXCLUDE_FILE"
	^self addVardata: ##attrFileOpenExcludeFile word: value!

tempFileOpenFileSelectorInfo
	"@vardata DocumentInfo TEMP_FILE_OPEN_FILE_SELECTOR_INFO"
	^self addVardata: ##tempFileOpenFileSelectorInfo size: 38!

tempFileOpenFileSelectorInfo: aBlock
	"@vardata DocumentInfo TEMP_FILE_OPEN_FILE_SELECTOR_INFO"
	aBlock value: (GCSDocumentInfo forPointer: (self addVardata: ##tempFileOpenFileSelectorInfo size: 38)).!

tempFsSelection
	"@vardata FileLongName TEMP_FS_SELECTION"
	^self addVardata: ##tempFsSelection size: 36!

hintFileOpenDontFilterDocumentSubDirs
	"@vardata void HINT_FILE_OPEN_DONT_FILTER_DOCUMENT_SUB_DIRS"
	^self addVardata: ##hintFileOpenDontFilterDocumentSubDirs!

tempFileOpenControlLastUi: value
	"@vardata word TEMP_FILE_OPEN_CONTROL_LAST_UI"
	^self addVardata: ##tempFileOpenControlLastUi word: value!

tempFileOpenControlDestinationPath: value
	"@vardata word TEMP_FILE_OPEN_CONTROL_DESTINATION_PATH"
	^self addVardata: ##tempFileOpenControlDestinationPath word: value!

tempFocSelectorInfo
	"@vardata FocFilePath TEMP_FOC_SELECTOR_INFO"
	^self addVardata: ##tempFocSelectorInfo size: 236!

tempFocSelectorInfo: aBlock
	"@vardata FocFilePath TEMP_FOC_SELECTOR_INFO"
	aBlock value: (GCSFocFilePath forPointer: (self addVardata: ##tempFocSelectorInfo size: 236)).!

tempFileOpenControlFileOperationInProgress
	"@vardata void TEMP_FILE_OPEN_CONTROL_FILE_OPERATION_IN_PROGRESS"
	^self addVardata: ##tempFileOpenControlFileOperationInProgress!

tempFileOpenControlNewDoc
	"@vardata DocumentInfo TEMP_FILE_OPEN_CONTROL_NEW_DOC"
	^self addVardata: ##tempFileOpenControlNewDoc size: 38!

tempFileOpenControlNewDoc: aBlock
	"@vardata DocumentInfo TEMP_FILE_OPEN_CONTROL_NEW_DOC"
	aBlock value: (GCSDocumentInfo forPointer: (self addVardata: ##tempFileOpenControlNewDoc size: 38)).!

tempFileOpenControlSomeIrDocsAreOpen
	"@vardata void TEMP_FILE_OPEN_CONTROL_SOME_IR_DOCS_ARE_OPEN"
	^self addVardata: ##tempFileOpenControlSomeIrDocsAreOpen!

!

!FileOpenControl methodsFor: 'Geos messages'!

openControlOpen: docInfo with: attr
	"@message void MSG_FILE_OPEN_CONTROL_OPEN(DocumentInfo *docInfo = cx:dx, ViewerAttributes attr = bp)"
	^self geosMessage: #[136 0 3 245 3 1 0] with: docInfo with: attr!

openControlGetViewerLibraryName: libName with: docInfo
	"@message ViewerInterfaceError MSG_FILE_OPEN_CONTROL_GET_VIEWER_LIBRARY_NAME(@stack FileLongName *libName, DocumentInfo *docInfo)= ax"
	^self geosMessage: #[136 1 96 8 3 3 1] with: libName with: docInfo!

openControlCreateNew: docInfo
	"@message Boolean MSG_FILE_OPEN_CONTROL_CREATE_NEW(DocumentInfo *docInfo = cx:dx)=carry"
	^self geosMessage: #[136 2 2 53 3 4] with: docInfo!

openControlDelete
	"@message void MSG_FILE_OPEN_CONTROL_DELETE()"
	^self geosMessage: #[136 3 2 0 0]!

openControlRenameCopy
	"@message void MSG_FILE_OPEN_CONTROL_RENAME_COPY()"
	^self geosMessage: #[136 4 2 0 0]!

openControlItemSelected: entryNumber with: fsFlags
	"@message void MSG_FILE_OPEN_CONTROL_ITEM_SELECTED( word entryNumber = cx, GenFileSelectorEntryFlags fsFlags = bp)"
	^self geosMessage: #[136 5 2 61 1 1 0] with: entryNumber with: fsFlags!

openControlSetDirectory: fDocDir
	"@message void MSG_FILE_OPEN_CONTROL_SET_DIRECTORY(FDocumentDir fDocDir = cx)"
	^self geosMessage: #[136 6 2 5 1 0] with: fDocDir!

openControlGetDirectory
	"@message FDocumentDir MSG_FILE_OPEN_CONTROL_GET_DIRECTORY()=cx"
	^self geosMessage: #[136 7 102 0 1]!

openControlGetFilterRoutine: filter
	"@message void MSG_FILE_OPEN_CONTROL_GET_FILTER_ROUTINE( GenFileSelectorGetFilterRoutineResults *filter = axcxdxbp)"
	^self geosMessage: #[136 8 198 0 3 0] with: filter!

openControlSubDirOpen: fDocDir
	"@message void MSG_FILE_OPEN_CONTROL_SUB_DIR_OPEN(FDocumentDir fDocDir=cx)"
	^self geosMessage: #[136 9 2 5 1 0] with: fDocDir!

openControlSubDirClose: fDocDir
	"@message void MSG_FILE_OPEN_CONTROL_SUB_DIR_CLOSE(FDocumentDir fDocDir=cx)"
	^self geosMessage: #[136 10 2 5 1 0] with: fDocDir!

openControlRenameDocument: renameCopyStruct
	"@message void MSG_FILE_OPEN_CONTROL_RENAME_DOCUMENT( FileOpenControlRenameCopyStruct *renameCopyStruct=ss:bp)"
	^self geosMessage: #[136 11 0 128 3 0] with: renameCopyStruct!

openControlCopyDocument: renameCopyStruct
	"@message void MSG_FILE_OPEN_CONTROL_COPY_DOCUMENT( FileOpenControlRenameCopyStruct *renameCopyStruct=ss:bp)"
	^self geosMessage: #[136 12 0 128 3 0] with: renameCopyStruct!

openControlChangeFeatures: setf with: clearf
	"@message void MSG_FILE_OPEN_CONTROL_CHANGE_FEATURES(FileOpenFeatures setf = cl, FileOpenFeatures clearf = ch)"
	^self geosMessage: #[136 13 2 17 1 1 0] with: setf with: clearf!

openControlGetFileSelectorOptr
	"@message optr MSG_FILE_OPEN_CONTROL_GET_FILE_SELECTOR_OPTR()= cx:dx"
	^self geosMessage: #[136 14 154 0 2]!

open
	"@message void MSG_FOC_OPEN()"
	^self geosMessage: #[136 15 2 0 0]!

close
	"@message void MSG_FOC_CLOSE()"
	^self geosMessage: #[136 16 2 0 0]!

createNew
	"@message void MSG_FOC_CREATE_NEW()"
	^self geosMessage: #[136 17 2 0 0]!

unloadViewerLibrary: gh
	"@message void MSG_FOC_UNLOAD_VIEWER_LIBRARY(GeodeHandle gh=cx)"
	^self geosMessage: #[136 18 2 5 1 0] with: gh!

nextPrevDocument: character
	"@message void MSG_FOC_NEXT_PREV_DOCUMENT(word character=cx)"
	^self geosMessage: #[136 19 2 5 1 0] with: character!

nextPrevGetNewDoc: oldDocName
	"@message void MSG_FOC_NEXT_PREV_GET_NEW_DOC(FileLongName *oldDocName=ss:bp)"
	^self geosMessage: #[136 20 0 128 3 0] with: oldDocName!

renameDoc
	"@message void MSG_FOC_RENAME_DOC()"
	^self geosMessage: #[136 21 2 0 0]!

copyDoc
	"@message void MSG_FOC_COPY_DOC()"
	^self geosMessage: #[136 22 2 0 0]!

checkIncludeExcludeDir: name
	"@message word MSG_FOC_CHECK_INCLUDE_EXCLUDE_DIR(FileLongName *name = ss:bp)= cx"
	^self geosMessage: #[136 23 100 128 3 1] with: name!

checkIncludeExcludeFile: token with: id
	"@message word MSG_FOC_CHECK_INCLUDE_EXCLUDE_FILE(dword token = cx:dx, word id = bp)= cx"
	^self geosMessage: #[136 24 103 245 2 1 1] with: token with: id!

openFolder
	"@message void MSG_FOC_OPEN_FOLDER()"
	^self geosMessage: #[136 25 2 0 0]!

setFileSelectorSelection: fileName
	"@message void MSG_FOC_SET_FILE_SELECTOR_SELECTION(FileLongName *fileName = ss:bp)"
	^self geosMessage: #[136 26 0 128 3 0] with: fileName!

openControlDeleteCallback
	"@message word MSG_FILE_OPEN_CONTROL_DELETE_CALLBACK()= ax"
	^self geosMessage: #[136 27 98 0 1]!

menu
	"@message void MSG_FOC_MENU()"
	^self geosMessage: #[136 28 2 0 0]!

createFolder
	"@message void MSG_FOC_CREATE_FOLDER()"
	^self geosMessage: #[136 29 2 0 0]!

copyDestReady
	"@message void MSG_FOC_COPY_DEST_READY()"
	^self geosMessage: #[136 30 2 0 0]!

moveDoc
	"@message void MSG_FOC_MOVE_DOC()"
	^self geosMessage: #[136 31 2 0 0]!

openControlCreateFolder
	"@message void MSG_FILE_OPEN_CONTROL_CREATE_FOLDER()"
	^self geosMessage: #[136 32 2 0 0]!

openControlRename
	"@message void MSG_FILE_OPEN_CONTROL_RENAME()"
	^self geosMessage: #[136 33 2 0 0]!

openControlCopy
	"@message void MSG_FILE_OPEN_CONTROL_COPY()"
	^self geosMessage: #[136 34 2 0 0]!

openControlMove
	"@message void MSG_FILE_OPEN_CONTROL_MOVE()"
	^self geosMessage: #[136 35 2 0 0]!

openControlChangeFeatures_16: setf with: clearf
	"@message void MSG_FILE_OPEN_CONTROL_CHANGE_FEATURES_16( FileOpenFeatures setf = cx, FileOpenFeatures clearf = dx )"
	^self geosMessage: #[136 36 2 53 1 1 0] with: setf with: clearf!

openControlGetUnreadDocument: docInfo
	"@message void MSG_FILE_OPEN_CONTROL_GET_UNREAD_DOCUMENT(DocumentInfo *docInfo = cx:dx)"
	^self geosMessage: #[136 37 2 53 3 0] with: docInfo!

openControlCloseAllBubbles
	"@message void MSG_FILE_OPEN_CONTROL_CLOSE_ALL_BUBBLES()"
	^self geosMessage: #[136 38 2 0 0]!

openControlLoadUnreadDocument: folder
	"@message void MSG_FILE_OPEN_CONTROL_LOAD_UNREAD_DOCUMENT(FDocumentDir folder=cx)"
	^self geosMessage: #[136 39 2 5 1 0] with: folder!

openControlCopyToSounds
	"@message void MSG_FILE_OPEN_CONTROL_COPY_TO_SOUNDS()"
	^self geosMessage: #[136 40 2 0 0]!

deleteFileOpVarDataViaQueue
	"@message void MSG_FOC_DELETE_FILE_OP_VAR_DATA_VIA_QUEUE()"
	^self geosMessage: #[136 41 2 0 0]!

openControlCopyViaIr
	"@message void MSG_FILE_OPEN_CONTROL_COPY_VIA_IR()"
	^self geosMessage: #[136 42 2 0 0]!

openControlCopyOneFileViaIr: block with: numFiles with: fileID
	"@message void MSG_FILE_OPEN_CONTROL_COPY_ONE_FILE_VIA_IR(hptr block = cx, word numFiles = dx, word fileID = bp)"
	^self geosMessage: #[136 43 3 245 1 1 1 0] with: block with: numFiles with: fileID!

openControlCopyViaIrCleanup: block with: numFiles
	"@message void MSG_FILE_OPEN_CONTROL_COPY_VIA_IR_CLEANUP(hptr block = cx, word numFiles = dx)"
	^self geosMessage: #[136 44 2 53 1 1 0] with: block with: numFiles!

openControlCopyViaIrMailboxError: block with: numFiles
	"@message void MSG_FILE_OPEN_CONTROL_COPY_VIA_IR_MAILBOX_ERROR(hptr block = cx, word numFiles = dx)"
	^self geosMessage: #[136 45 2 53 1 1 0] with: block with: numFiles!

openControlCopyViaIrTooManyFiles: block with: numFiles
	"@message void MSG_FILE_OPEN_CONTROL_COPY_VIA_IR_TOO_MANY_FILES(hptr block = cx, word numFiles = dx)"
	^self geosMessage: #[136 46 2 53 1 1 0] with: block with: numFiles!

!

!ViewerDialog comment!
Library viewer, file viewer.goh! !

!ViewerDialog class methodsFor: 'library linkage'!

library
	^79!

entry
	^3!
!

!ViewerDialog methodsFor: 'Geos instance variables'!

vdiDestination
	"@instance optr VDI_destination"
	^self dwordAt: 21!

vdiDestination: value
	"@instance optr VDI_destination"
	^self dwordAt: 21 put: value!

vdiCloseMsg
	"@instance Message VDI_closeMsg"
	^self wordAt: 25!

vdiCloseMsg: value
	"@instance Message VDI_closeMsg"
	^self wordAt: 25 put: value!

vdiNextPrevMsg
	"@instance Message VDI_nextPrevMsg"
	^self wordAt: 27!

vdiNextPrevMsg: value
	"@instance Message VDI_nextPrevMsg"
	^self wordAt: 27 put: value!

vdiAttr
	"@instance ViewerAttributes VDI_attr"
	^self wordAt: 29!

vdiAttr: value
	"@instance ViewerAttributes VDI_attr"
	^self wordAt: 29 put: value!

vdiDialogAttr
	"@instance ViewerDialogAttributes VDI_dialogAttr"
	^self wordAt: 31!

vdiDialogAttr: value
	"@instance ViewerDialogAttributes VDI_dialogAttr"
	^self wordAt: 31 put: value!

!

!ViewerDialog methodsFor: 'Geos vardata'!

tempHeapspaceToken: value
	"@vardata ReservationHandle TEMP_HEAPSPACE_TOKEN"
	^self addVardata: ##tempHeapspaceToken word: value!

!

!ViewerDialog methodsFor: 'Geos messages'!

setViewerParams: viewerParams
	"@message void MSG_VD_SET_VIEWER_PARAMS(ViewerParams *viewerParams=cx:dx)"
	^self geosMessage: #[106 0 2 53 3 0] with: viewerParams!

close: viewerLibHandle with: closeStatus
	"@message void MSG_VD_CLOSE(GeodeHandle viewerLibHandle=cx, ViewerCloseStatus closeStatus=dx)"
	^self geosMessage: #[106 1 2 53 1 1 0] with: viewerLibHandle with: closeStatus!

setDialogAttr: attrSet with: attrClear
	"@message void MSG_VD_SET_DIALOG_ATTR(ViewerDialogAttributes attrSet=cx, ViewerDialogAttributes attrClear=dx)"
	^self geosMessage: #[106 2 2 53 1 1 0] with: attrSet with: attrClear!

setHeapspaceToken: token
	"@message void MSG_VD_SET_HEAPSPACE_TOKEN(ReservationHandle token=cx)"
	^self geosMessage: #[106 3 2 5 1 0] with: token!

returnHeapspace
	"@message void MSG_VD_RETURN_HEAPSPACE()"
	^self geosMessage: #[106 4 2 0 0]!

!

!ViewerMenuInteraction comment!
Library viewer, file viewer.goh! !

!ViewerMenuInteraction class methodsFor: 'library linkage'!

library
	^79!

entry
	^39!
!

!ViewerMenuInteraction methodsFor: 'Geos instance variables'!

vmiiAltParent
	"@instance optr VMII_altParent"
	^self dwordAt: 21!

vmiiAltParent: value
	"@instance optr VMII_altParent"
	^self dwordAt: 21 put: value!

!

!ViewerMenuInteraction methodsFor: 'Geos vardata'!

!

!ViewerMenuInteraction methodsFor: 'Geos messages'!

setAlternateVscParent: altParent
	"@message void MSG_VMI_SET_ALTERNATE_VSC_PARENT(optr altParent = cx:bp)"
	^self geosMessage: #[106 0 2 61 2 0] with: altParent!

!

!ViewerControl comment!
Library viewer, file viewer.goh! !

!ViewerControl class methodsFor: 'library linkage'!

library
	^79!

entry
	^2!
!

!ViewerControl methodsFor: 'Geos instance variables'!

vciDocHandle
	"@instance hptr VCI_docHandle"
	^self wordAt: 25!

vciDocHandle: value
	"@instance hptr VCI_docHandle"
	^self wordAt: 25 put: value!

vciAttr
	"@instance ViewerControlAttributes VCI_attr"
	^self wordAt: 27!

vciAttr: value
	"@instance ViewerControlAttributes VCI_attr"
	^self wordAt: 27 put: value!

vciAutoSaveHandle
	"@instance hptr VCI_autoSaveHandle"
	^self wordAt: 29!

vciAutoSaveHandle: value
	"@instance hptr VCI_autoSaveHandle"
	^self wordAt: 29 put: value!

vciAutoSaveID
	"@instance word VCI_autoSaveID"
	^self wordAt: 31!

vciAutoSaveID: value
	"@instance word VCI_autoSaveID"
	^self wordAt: 31 put: value!

!

!ViewerControl methodsFor: 'Geos vardata'!

tempViewerDocInfo
	"@vardata DocumentInfo TEMP_VIEWER_DOC_INFO"
	^self addVardata: ##tempViewerDocInfo size: 38!

tempViewerDocInfo: aBlock
	"@vardata DocumentInfo TEMP_VIEWER_DOC_INFO"
	aBlock value: (GCSDocumentInfo forPointer: (self addVardata: ##tempViewerDocInfo size: 38)).!

attrViewerTextObject: value
	"@vardata ChunkHandle ATTR_VIEWER_TEXT_OBJECT"
	^self addVardata: ##attrViewerTextObject word: value!

tempRegisterInfo
	"@vardata RegisterInfo TEMP_REGISTER_INFO"
	^self addVardata: ##tempRegisterInfo size: 6!

tempRegisterInfo: aBlock
	"@vardata RegisterInfo TEMP_REGISTER_INFO"
	aBlock value: (GCSRegisterInfo forPointer: (self addVardata: ##tempRegisterInfo size: 6)).!

attrViewerControlShowSaveProgressDialogThreshold: value
	"@vardata dword ATTR_VIEWER_CONTROL_SHOW_SAVE_PROGRESS_DIALOG_THRESHOLD"
	^self addVardata: ##attrViewerControlShowSaveProgressDialogThreshold dword: value!

tempViewerLoadingMeter: value
	"@vardata optr TEMP_VIEWER_LOADING_METER"
	^self addVardata: ##tempViewerLoadingMeter dword: value!

hintViewerNoDocumentRename
	"@vardata void HINT_VIEWER_NO_DOCUMENT_RENAME"
	^self addVardata: ##hintViewerNoDocumentRename!

tempViewerOriginalText
	"@vardata ViewerTextState TEMP_VIEWER_ORIGINAL_TEXT"
	^self addVardata: ##tempViewerOriginalText size: 10!

tempViewerOriginalText: aBlock
	"@vardata ViewerTextState TEMP_VIEWER_ORIGINAL_TEXT"
	aBlock value: (GCSViewerTextState forPointer: (self addVardata: ##tempViewerOriginalText size: 10)).!

attrViewerControlShowDeleteProgressDialogThreshold: value
	"@vardata dword ATTR_VIEWER_CONTROL_SHOW_DELETE_PROGRESS_DIALOG_THRESHOLD"
	^self addVardata: ##attrViewerControlShowDeleteProgressDialogThreshold dword: value!

!

!ViewerControl methodsFor: 'Geos messages'!

open: docInfo
	"@message Boolean MSG_VIEWER_OPEN(DocumentInfo *docInfo=cx:dx)=ax"
	^self geosMessage: #[108 0 98 53 3 4] with: docInfo!

openDocument: docAccess
	"@message dword MSG_VIEWER_OPEN_DOCUMENT(FDocAccess docAccess=cx)=ax.cx"
	^self geosMessage: #[108 1 134 5 1 2] with: docAccess!

closeDocument
	"@message void MSG_VIEWER_CLOSE_DOCUMENT()"
	^self geosMessage: #[108 2 2 0 0]!

attachUi: docHandle
	"@message Boolean MSG_VIEWER_ATTACH_UI(DocumentHandle docHandle=cx)=carry"
	^self geosMessage: #[108 3 2 5 1 4] with: docHandle!

setTitle: titleText
	"@message void MSG_VIEWER_SET_TITLE(TCHAR *titleText=cx:dx)"
	^self geosMessage: #[108 4 2 53 3 0] with: titleText!

close
	"@message ViewerCloseStatus MSG_VIEWER_CLOSE()=ax"
	^self geosMessage: #[108 5 98 0 1]!

save
	"@message FoamSaveAction MSG_VIEWER_SAVE()=ax"
	^self geosMessage: #[108 6 98 0 1]!

delete
	"@message void MSG_VIEWER_DELETE()"
	^self geosMessage: #[108 7 2 0 0]!

getTextObjectOffset
	"@message ChunkHandle MSG_VIEWER_GET_TEXT_OBJECT_OFFSET()=dx"
	^self geosMessage: #[108 8 106 0 1]!

returnState
	"@message hptr MSG_VIEWER_RETURN_STATE()=dx"
	^self geosMessage: #[108 9 106 0 1]!

openFromState: hStateBlock
	"@message Boolean MSG_VIEWER_OPEN_FROM_STATE(hptr hStateBlock=dx)=ax"
	^self geosMessage: #[108 10 98 6 1 4] with: hStateBlock!

autoSaveStart
	"@message void MSG_VIEWER_AUTO_SAVE_START()"
	^self geosMessage: #[108 11 2 0 0]!

autoSave
	"@message void MSG_VIEWER_AUTO_SAVE()"
	^self geosMessage: #[108 12 2 0 0]!

autoSaveStop
	"@message void MSG_VIEWER_AUTO_SAVE_STOP()"
	^self geosMessage: #[108 13 2 0 0]!

openReadOnly: docInfo
	"@message Boolean MSG_VIEWER_OPEN_READ_ONLY(DocumentInfo *docInfo=cx:dx)"
	^self geosMessage: #[108 14 2 53 3 4] with: docInfo!

getDocumentInfo: docInfo
	"@message void MSG_VIEWER_GET_DOCUMENT_INFO(DocumentInfo *docInfo=cx:dx)"
	^self geosMessage: #[108 15 2 53 3 0] with: docInfo!

getMessageFormat
	"@message MailboxDataFormat MSG_VIEWER_GET_MESSAGE_FORMAT()= cx:dx"
	^self geosMessage: #[108 16 154 0 2]!

getAttributes
	"@message ViewerControlAttributes MSG_VIEWER_GET_ATTRIBUTES()= cx"
	^self geosMessage: #[108 17 102 0 1]!

openTextOnly: text
	"@message void MSG_VIEWER_OPEN_TEXT_ONLY(TCHAR *text=cx:dx)"
	^self geosMessage: #[108 18 2 53 3 0] with: text!

getMessageToken: result with: format
	"@message void MSG_VIEWER_GET_MESSAGE_TOKEN(ViewerMessageToken *result=cxdxbpax, MailboxDataFormat format = cx:dx)"
	^self geosMessage: #[108 19 202 53 3 2 0] with: result with: format!

getSmText
	"@message dword MSG_VIEWER_GET_SM_TEXT()= ax.cx"
	^self geosMessage: #[108 20 134 0 2]!

saveBeforeMailboxSend
	"@message void MSG_VIEWER_SAVE_BEFORE_MAILBOX_SEND()"
	^self geosMessage: #[108 21 2 0 0]!

notifySendControls
	"@message void MSG_VIEWER_NOTIFY_SEND_CONTROLS()"
	^self geosMessage: #[108 22 2 0 0]!

autoSaveExecute
	"@message void MSG_VIEWER_AUTO_SAVE_EXECUTE()"
	^self geosMessage: #[108 23 2 0 0]!

appendDosText: filePosition
	"@message Boolean MSG_VIEWER_APPEND_DOS_TEXT(dword filePosition=cx:dx)=carry"
	^self geosMessage: #[108 24 2 53 2 4] with: filePosition!

appendTextTrItem: block
	"@message Boolean MSG_VIEWER_APPEND_TEXT_TR_ITEM(VMBlockHandle block=cx)=carry"
	^self geosMessage: #[108 25 2 5 1 4] with: block!

precheckMailboxMessageFormat: format
	"@message void MSG_VIEWER_PRECHECK_MAILBOX_MESSAGE_FORMAT( MailboxDataFormat format = cx:dx)"
	^self geosMessage: #[108 26 2 53 2 0] with: format!

!

!ViewerLoadingMeter comment!
Library viewer, file viewer.goh! !

!ViewerLoadingMeter class methodsFor: 'library linkage'!

library
	^79!

entry
	^35!
!

!ViewerLoadingMeter methodsFor: 'Geos instance variables'!

vlmiFocusObject
	"@instance optr VLMI_focusObject"
	^self dwordAt: 25!

vlmiFocusObject: value
	"@instance optr VLMI_focusObject"
	^self dwordAt: 25 put: value!

!

!ViewerLoadingMeter methodsFor: 'Geos vardata'!

!

!ViewerLoadingMeter methodsFor: 'Geos messages'!

loadingMeterSetValue: value
	"@message void MSG_VIEWER_LOADING_METER_SET_VALUE(dword value = dx:cx)"
	^self geosMessage: #[108 0 2 46 2 0] with: value!

loadingMeterSetMaximum: max
	"@message void MSG_VIEWER_LOADING_METER_SET_MAXIMUM(dword max = dx:cx)"
	^self geosMessage: #[108 1 2 46 2 0] with: max!

loadingMeterSetFocusObject: obj
	"@message void MSG_VIEWER_LOADING_METER_SET_FOCUS_OBJECT(optr obj = cx:dx)"
	^self geosMessage: #[108 2 2 53 2 0] with: obj!

!

!ViewerPrintControl comment!
Library viewer, file viewer.goh! !

!ViewerPrintControl class methodsFor: 'library linkage'!

library
	^79!

entry
	^34!
!

!ViewerPrintControl methodsFor: 'Geos instance variables'!

vpciFlags
	"@instance ViewerPrintControlFlags VPCI_flags"
	^self byteAt: 63!

vpciFlags: value
	"@instance ViewerPrintControlFlags VPCI_flags"
	^self byteAt: 63 put: value!

!

!ViewerPrintControl methodsFor: 'Geos vardata'!

!

!ViewerPrintControl methodsFor: 'Geos messages'!

checkForFaxForwarding: pm
	"@message Boolean MSG_VPC_CHECK_FOR_FAX_FORWARDING(PrinterMode pm = cl)= ax"
	^self geosMessage: #[110 0 98 1 1 4] with: pm!

alwaysTile
	"@message void MSG_VPC_ALWAYS_TILE()"
	^self geosMessage: #[110 1 2 0 0]!

alwaysScale
	"@message void MSG_VPC_ALWAYS_SCALE()"
	^self geosMessage: #[110 2 2 0 0]!

checkForFaxing
	"@message Boolean MSG_VPC_CHECK_FOR_FAXING()= ax"
	^self geosMessage: #[110 3 98 0 4]!

!

!ViewerSendControl comment!
Library viewer, file viewer.goh! !

!ViewerSendControl class methodsFor: 'library linkage'!

library
	^79!

entry
	^23!
!

!ViewerSendControl methodsFor: 'Geos instance variables'!

!

!ViewerSendControl methodsFor: 'Geos vardata'!

attrViewerSendControlReplySendMoniker: value
	"@vardata ChunkHandle ATTR_VIEWER_SEND_CONTROL_REPLY_SEND_MONIKER"
	^self addVardata: ##attrViewerSendControlReplySendMoniker word: value!

tempViewerSendControlSingleTransport
	"@vardata MailboxMediaTransport TEMP_VIEWER_SEND_CONTROL_SINGLE_TRANSPORT"
	^self addVardata: ##tempViewerSendControlSingleTransport size: 10!

tempViewerSendControlSingleTransport: aBlock
	"@vardata MailboxMediaTransport TEMP_VIEWER_SEND_CONTROL_SINGLE_TRANSPORT"
	aBlock value: (GCSMailboxMediaTransport forPointer: (self addVardata: ##tempViewerSendControlSingleTransport size: 10)).!

tempViewerSendControlComplexMoniker
	"@vardata GetComplexMoniker TEMP_VIEWER_SEND_CONTROL_COMPLEX_MONIKER"
	^self addVardata: ##tempViewerSendControlComplexMoniker size: 6!

tempViewerSendControlComplexMoniker: aBlock
	"@vardata GetComplexMoniker TEMP_VIEWER_SEND_CONTROL_COMPLEX_MONIKER"
	aBlock value: (GCSGetComplexMoniker forPointer: (self addVardata: ##tempViewerSendControlComplexMoniker size: 6)).!

tempViewerSendControlReplyInProgress
	"@vardata void TEMP_VIEWER_SEND_CONTROL_REPLY_IN_PROGRESS"
	^self addVardata: ##tempViewerSendControlReplyInProgress!

tempViewerSendControlNoSeekReplyBarIsOk
	"@vardata void TEMP_VIEWER_SEND_CONTROL_NO_SEEK_REPLY_BAR_IS_OK"
	^self addVardata: ##tempViewerSendControlNoSeekReplyBarIsOk!

tempViewerSendControlEnableOptionsOptr
	"@vardata void TEMP_VIEWER_SEND_CONTROL_ENABLE_OPTIONS_OPTR"
	^self addVardata: ##tempViewerSendControlEnableOptionsOptr!

attrViewerSendControlOptionsOptr
	"@vardata VSCOptionsAction ATTR_VIEWER_SEND_CONTROL_OPTIONS_OPTR"
	^self addVardata: ##attrViewerSendControlOptionsOptr size: 4!

attrViewerSendControlOptionsOptr: aBlock
	"@vardata VSCOptionsAction ATTR_VIEWER_SEND_CONTROL_OPTIONS_OPTR"
	aBlock value: (GCSVSCOptionsAction forPointer: (self addVardata: ##attrViewerSendControlOptionsOptr size: 4)).!

!

!ViewerSendControl methodsFor: 'Geos messages'!

connect: newOutput with: newParentOffset
	"@message void MSG_VSC_CONNECT(optr newOutput = cx:dx, word newParentOffset = bp)"
	^self geosMessage: #[110 0 3 245 2 1 0] with: newOutput with: newParentOffset!

disconnect: oldOutput with: oldParentOffset
	"@message void MSG_VSC_DISCONNECT(optr oldOutput = cx:dx, word oldParentOffset = bp)"
	^self geosMessage: #[110 1 3 245 2 1 0] with: oldOutput with: oldParentOffset!

setReplyAddresses: vscReplyInfo
	"@message void MSG_VSC_SET_REPLY_ADDRESSES(MemHandle vscReplyInfo)"
	^self geosMessage: #[110 2 1 0 1 0] with: vscReplyInfo!

cancelReply
	"@message void MSG_VSC_CANCEL_REPLY()"
	^self geosMessage: #[110 3 2 0 0]!

setOptionsAction: optionsTree
	"@message void MSG_VSC_SET_OPTIONS_ACTION(optr optionsTree = cx:dx)"
	^self geosMessage: #[110 4 2 53 2 0] with: optionsTree!

!

